--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI - must be in the order than the source class ids
fn DisplaySourceName =
(
	#("Omnilight", "Target Spot", "Free Directional Light", "Free Spot", "Target Directional Light")
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	#(48, 48, 48, 48, 48) --Light 
)

--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(#(0x1011L, 0x0L) /*Omnilight*/,#(0x1012L, 0x0L)/*Target Spot*/, #(0x1013L, 0x0L)/*Free Directional Light*/, #(0x1014L, 0x0L)/*Free Spot*/, #(0x1015L, 0x0L)/*Target directional light*/)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	#("Free Light", "Target Light", "Free Disc", "Target Disc", "Free Area", "Target_Area")
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	#(48, 48, 48, 48, 48, 48) --Light
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(#(0x32375fccL, 0xb025cf0L)/*Free_Light*/, #(0x658d4f97L, 0x72cd4259L)/*Target_Light*/, #(0x5bcc6d42L, 0xc4f430eL)/*Free_Disc*/, #(0x38732348L, 0x201758b3L)/*Target_Disc*/, #(0x36507d92L, 0x105a1a47L)/*Free_Area*/, #(0x71794f9dL, 0x70ae52f2L)/*Target_Area*/)
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	"Converts from a standard light to a Photometric Light"
)
--This internal function does the parameter mapping
fn ConvertFromTargetSpotLightToPhotometric legacyLight photometric =
(
	if ((false == VerifySource legacyLight) or 
		(false == VerifyDestination photometric)
		) do
	(
		--Not the suitable nodes
		return undefined
	)		
	photometric
)

fn CreateDestinationBasedOnSource legacyLight =
(	
	if (false == VerifySource legacyLight)  do
	(
		--Not the suitable node
		return undefined
	)
	
	local photometricLight
	
	if(#omni == legacyLight.type) then
	(
			photometricLight = Free_Light type:"Free_Point" distribution:0/*Uniformed spherical*/
	) 
	else if(#targetSpot == legacyLight.type) then 
	(
			photometricLight = Target_Light type:"Target_Point" distribution:1/*Spotlight*/
	)	
	else if(#freeSpot == legacyLight.type) then
	(
			photometricLight = Free_Light type:"Free_Point" distribution:1/*Spotlight*/
	)
	else if(#targetDirect == legacyLight.type) then
	(
			if(1 == legacyLight.coneShape) then --cone shape is a circle
			(
				photometricLight = Target_Disc type:"Target_Disc" distribution:2/*Uniformed Hemispherical*/
			)
			else if (2 == legacyLight.coneShape) do --cone shape is a rectangle
			(
				photometricLight = Target_Area type:"Target_Area" distribution:2/*Uniformed Hemispherical*/
			)
	)
	else if(#freeDirect == legacyLight.type) do
	(
			if(1 == legacyLight.coneShape) then --cone shape is a circle
			(
				photometricLight = Free_Disc type:"Free_Disc" distribution:2/*Uniformed Hemispherical*/
			)
			else if (2 == legacyLight.coneShape) do --cone shape is a rectangle
			(
				photometricLight = Free_Area type:"Free_Area" distribution:2/*Uniformed Hemispherical*/
			)			
	)	

	photometricLight
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion legacyLight=
(
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyLight
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a Photometric light	
	local photometricLight = photometricLight = Free_Light type:"Free_Point" distribution:0/*Uniformed spherical*/

	newLight			    = newNodesList[1]
	newLight.name        	= photometricLight.name --copy its name
	newLight.baseobject 	= photometricLight.baseobject
	
	--Delete the dummy physical light from the scene
	delete photometricLight
	
	--return the new created light node
	newLight

)

--Main entry point from this script
--This function handles the node's creation
fn Conversion legacyLight =
(
	if (false == VerifySource legacyLight)  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyLight
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a Photometric light	
	local photometricLight = CreateDestinationBasedOnSource legacyLight
	
	--Call the parameters mapping function to convert
	ConvertFromTargetSpotLightToPhotometric legacyLight photometricLight
	
	newLight			    = newNodesList[1]
	newLight.name        	= photometricLight.name --copy its name
	newLight.baseobject 	= photometricLight.baseobject
	
	--Delete the dummy physical light from the scene
	delete photometricLight
	
	--return the new created light node
	newLight
)